import java.util.ArrayList;
import java.util.List;

public class Main {
    public static void main(String[] args) {
        List<Drink> drinks = new ArrayList<>();

        drinks.add(new Coffee("Espresso", "small", 3.50, 2));
        drinks.add(new Tea("Green Tea", "medium", 2.00, "green"));
        drinks.add(new Coffee("Cappuccino", "large", 4.00, 3));

        for (Drink drink : drinks) {
            System.out.println(drink);
        }
    }

    static class Drink {
        protected String name;
        protected double price;
        protected String size;

        public Drink(String name, String size, double price) {
            this.name = name;
            this.size = size;
            this.price = price;
        }

        @Override
        public String toString() {
            return "Drink: " + name + ", Size: " + size + ", Price: " + price;
        }
    }

    static class Coffee extends Drink {
        private int strength;

        public Coffee(String name, String size, double price, int strength) {
            super(name, size, price);
            this.strength = strength;
        }

        @Override
        public String toString() {
            return "Coffee: " + name + ", Size: " + size + ", Strength: " + strength + ", Price: " + price;
        }
    }

    static class Tea extends Drink {
        private String type;

        public Tea(String name, String size, double price, String type) {
            super(name, size, price);
            this.type = type;
        }

        @Override
        public String toString() {
            return "Tea: " + name + ", Size: " + size + ", Type: " + type + ", Price: " + price;
        }
    }
}
