using System;
using System.Collections.Generic;

class Drink
{
    protected string name;
    protected double price;
    protected string size;

    public Drink(string name, string size, double price)
    {
        this.name = name;
        this.size = size;
        this.price = price;
    }

    public override string ToString()
    {
        return $"Drink: {name}, Size: {size}, Price: {price}";
    }
}

class Coffee : Drink
{
    private int strength;

    public Coffee(string name, string size, double price, int strength)
        : base(name, size, price)
    {
        this.strength = strength;
    }

    public override string ToString()
    {
        return $"Coffee: {name}, Size: {size}, Strength: {strength}, Price: {price}";
    }
}

class Tea : Drink
{
    private string type;

    public Tea(string name, string size, double price, string type)
        : base(name, size, price)
    {
        this.type = type;
    }

    public override string ToString()
    {
        return $"Tea: {name}, Size: {size}, Type: {type}, Price: {price}";
    }
}

class Program
{
    static void Main(string[] args)
    {
        List<Drink> drinks = new List<Drink>();

        drinks.Add(new Coffee("Espresso", "small", 3.50, 2));
        drinks.Add(new Tea("Green Tea", "medium", 2.00, "green"));
        drinks.Add(new Coffee("Cappuccino", "large", 4.00, 3));

        foreach (Drink drink in drinks)
        {
Console.WriteLine(drink);
        }
    }
}

