import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Scanner;

public class DateDifference {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        System.out.print("Въведете началната дата във формат ГГГГ-мм-дд: ");
        String inputDate = scanner.nextLine();
        
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate prevDate = LocalDate.parse(inputDate, formatter);
        LocalDate today = LocalDate.now();
        
        long diffOfDates = ChronoUnit.DAYS.between(prevDate, today);
        System.out.println("Разликата е " + diffOfDates + " дни");
        
        if (diffOfDates > 7) {
            System.out.println("Разликата е повече от 7 дни");
        } else if (diffOfDates == 7) {
            System.out.println("Разликата е точно 7 дни");
        } else {
            System.out.println("Разликата е по-малко от 7 дни");
        }
        
        scanner.close();
    }
}
